﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>

  <!--Horizontal Alignment Legal Description Report-->
  <xsl:template match="/">
    <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
    <html lang="en">
      <head>
        <link rel="stylesheet" type="text/css" href="../_Themes/engineer/theme.css" />
        <link rel="stylesheet" type="text/css" href="_Themes/engineer/theme.css" />
        <!--link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme-kaw.css"/-->
        <!-- Title displayed in browser Title Bar -->
        <!--title>Horizontal Alignment Legal Description</title-->
      </head>
      <body>
        <xsl:for-each select="InRoads">
          <p lang="en">
            <!-- Report Title -->
            <!--h2>Horizontal Alignment Legal Description</h2-->
            <xsl:for-each select="GeometryProject">
              <xsl:variable name="ProjNum">
                <xsl:value-of select="@name" />
              </xsl:variable>
              <xsl:variable name="PC">
                <xsl:value-of select="@description" />
              </xsl:variable>
              <xsl:for-each select="HorizontalAlignment">
                <xsl:variable name="Date">
                  <xsl:value-of select="@lastRevisedDate" />
                </xsl:variable>
                <xsl:variable name="ParNum">
                  <xsl:value-of select="@name" />
                </xsl:variable>
                <h3>
                  <center>
                    <b>EXHIBIT "A"</b>
                    <br />
                    <br />
 PROJECT NUMBER: <xsl:value-of select="$ProjNum" />
		    <br />
 PARCEL NUMBER: <xsl:value-of select="$ParNum" />
		    <br />
 PROJECT CODE: <xsl:value-of select="$PC" />
		    <br />
 DATE: <xsl:value-of select="cif:date()" />
		    <br /><th class="underline" lang="en">DESCRIPTION</th></center>
                </h3>
                <br />
                <left>A tract or parcel of land No.  <xsl:value-of select="$ParNum" /> of the Department of Transportation, State of Colorado Project No. <xsl:value-of select="$ProjNum" /> containing <xsl:value-of select="cif:acreFormat(number(@area), 0)" /> sq. ft. (<xsl:value-of select="cif:acreFormat(number(@area) div 43560, 3)" /> acres), more or less, in Section XX, Township X X, Range X X, of the X Principal Meridian, in X County, Colorado, said tract or parcel being more particularly described as follows:
<br />
		<br />
Commencing at a point, whence XXXX, said point also being the TRUE POINT OF BEGINNING;<br /><br /><xsl:apply-templates />
	The above described parcel contains <xsl:value-of select="cif:acreFormat(number(@area), 0)" /> sq. ft. (<xsl:value-of select="cif:acreFormat(number(@area) div 43560, 3)" /> acres), more or less.<br />
		<br />
Basis of Bearings: All bearings are based on a line between .....
	</left>
              </xsl:for-each>
            </xsl:for-each>
          </p>
        </xsl:for-each>
      </body>
    </html>
  </xsl:template>
  <!-- Horizontal Line -->
  <xsl:template match="HorizontalLine">
    <xsl:choose>
      <xsl:when test="position() = 1">
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />.  Thence<xsl:value-of select="cif:directionFormat(number(@direction))" />, a distance of	<xsl:value-of select="cif:distanceFormat(number(@length))" /> feet;
	</blockquote>
        <br />
      </xsl:when>
      <xsl:when test="position() = last()">
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />. Thence <xsl:value-of select="cif:directionFormat(number(@direction))" />,
 a distance of 
<xsl:value-of select="cif:distanceFormat(number(@length))" /> 
feet, more or less, to the TRUE POINT OF BEGINNING.

	</blockquote>
        <br />
      </xsl:when>
      <xsl:otherwise>
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />.  Thence <xsl:value-of select="cif:directionFormat(number(@direction))" />,
 a distance of 
<xsl:value-of select="cif:distanceFormat(number(@length))" /> feet;
	</blockquote>
        <br />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- Horizontal Circle -->
  <xsl:template match="HorizontalCircle">
    <xsl:choose>
      <xsl:when test="position() = 1">
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />.  Thence on the arc of a curve to the 
<xsl:if test="@rotationDirection='ccw'">
 left, </xsl:if><xsl:if test="@rotationDirection='cw'">
 right, 
</xsl:if>
  a radius of
 <xsl:value-of select="cif:distanceFormat(number(@radius))" />
feet, a central angle of
	<xsl:value-of select="cif:angularFormat(number(@delta),$xslAngularFormat, $xslAngularPrecision, $xslAngularMethod)" />,
 a distance of
 <xsl:value-of select="cif:distanceFormat(number(@length), $xslDistancePrecision)" />  feet, (a chord bearing 
<xsl:value-of select="cif:directionFormat(number(@chordDirection))" />,
 a distance of
 <xsl:value-of select="cif:distanceFormat(number(@chord), $xslDistancePrecision)" />
 feet);
				
	</blockquote>
        <br />
        <br />
      </xsl:when>
      <xsl:when test="position() = last()">
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />.  Thence on the arc of a curve to the <xsl:if test="@rotationDirection='ccw'">
  left, 
 </xsl:if><xsl:if test="@rotationDirection='cw'">
  right, 
</xsl:if>
	a radius of
 <xsl:value-of select="cif:distanceFormat(number(@radius))" /> feet, a central angle of
 <xsl:value-of select="cif:angularFormat(number(@delta))" />, a distance of 
<xsl:value-of select="cif:distanceFormat(number(@length))" />
 feet, (a chord bearing <xsl:value-of select="cif:directionFormat(number(@chordDirection))" />,
 a distance of
 <xsl:value-of select="cif:distanceFormat(number(@chord))" />
 feet), more or less, to the TRUE POINT OF BEGINNING.<br />
	</blockquote>
        <br />
      </xsl:when>
      <xsl:otherwise>
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />.  Thence on the arc of a curve to the 
<xsl:if test="@rotationDirection='ccw'"> left, </xsl:if><xsl:if test="@rotationDirection='cw'"> right, </xsl:if>
 a radius of
 <xsl:value-of select="cif:distanceFormat(number(@radius))" />
	feet, a central angle of
 <xsl:value-of select="cif:angularFormat(number(@delta))" />, a distance of <xsl:value-of select="cif:distanceFormat(number(@length))" />
 feet, (a chord bearing <xsl:value-of select="cif:directionFormat(number(@chordDirection))" />, a distance of
 <xsl:value-of select="cif:distanceFormat(number(@chord))" />
 feet);
	</blockquote>
        <br />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- Horizontal Spiral -->
  <xsl:template match="HorizontalSpiral">
    <xsl:choose>
      <xsl:when test="position() = 1">
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />.  Thence on the arc of a <xsl:value-of select="cif:distanceFormat(number(@length))" />
 foot spiral curve to the
 <xsl:if test="@rotationDirection='ccw'">
 left, </xsl:if><xsl:if test="@rotationDirection='cw'">
  right, 
</xsl:if>
	a beginning radius of 
<xsl:value-of select="cif:distanceFormat(number(@startRadius))" />
 feet, an ending radius of
 <xsl:value-of select="cif:distanceFormat(number(@endRadius))" />
 feet, a Theta angle of
 <xsl:value-of select="cif:angularFormat(number(@thetaAngle))" />, (a chord bearing
 <xsl:value-of select="cif:directionFormat(number(@chordDirection))" />,
 a distance of
 <xsl:value-of select="cif:distanceFormat(number(@longChord))" /> feet);<br /><br />
	</blockquote>
      </xsl:when>
      <xsl:when test="position() = last()">
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />.  Thence on the arc of a <xsl:value-of select="cif:distanceFormat(number(@length))" />
 foot spiral curve to the
 <xsl:if test="@rotationDirection='ccw'">
 left, </xsl:if><xsl:if test="@rotationDirection='cw'">
 right, 
</xsl:if>
 a beginning radius of <xsl:value-of select="cif:distanceFormat(number(@startRadius))" />
 feet, an ending radius of
 <xsl:value-of select="cif:distanceFormat(number(@endRadius))" />
 feet, a Theta angle of <xsl:value-of select="cif:angularFormat(number(@thetaAngle))" />, (a chord bearing <xsl:value-of select="cif:directionFormat(number(@chordDirection))" />,
 a distance of
 <xsl:value-of select="cif:distanceFormat(number(@longChord))" />
 feet), more or less, to the TRUE POINT OF BEGINNING.
	</blockquote>
        <br />
      </xsl:when>
      <xsl:otherwise>
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />.  Thence on the arc of a <xsl:value-of select="cif:distanceFormat(number(@length))" />
 foot spiral curve to the <xsl:if test="@rotationDirection='ccw'">
 left, </xsl:if><xsl:if test="@rotationDirection='cw'">
 right, </xsl:if>
 a beginning radius of <xsl:value-of select="cif:distanceFormat(number(@startRadius))" />
 feet, an ending radius of
 <xsl:value-of select="cif:distanceFormat(number(@endRadius))" /> feet, a Theta angle of
 <xsl:value-of select="cif:angularFormat(number(@thetaAngle))" />, (a chord bearing
 <xsl:value-of select="cif:directionFormat(number(@chordDirection))" />,
 a distance of
 <xsl:value-of select="cif:distanceFormat(number(@longChord))" /> feet); 
	</blockquote>
        <br />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>